/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import libsidplay.sidtune.PSid;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.CBMCodeUtils;
import libsidutils.IOUtils;
import libsidutils.assembler.KickAssembler;
import libsidutils.assembler.KickAssemblerResult;

class Mus
extends PSid {
    private static final String MUS_DRIVER1_ASM = "/libsidplay/sidtune/musdriver1.asm";
    private static final String MUS_DRIVER1_BIN = "/libsidplay/sidtune/musdriver1.bin";
    private static final String MUS_DRIVER2_ASM = "/libsidplay/sidtune/musdriver2.asm";
    private static final String MUS_DRIVER2_BIN = "/libsidplay/sidtune/musdriver2.bin";
    private static final List<String> DEFAULT_MUS_NAMES = Arrays.asList(".mus", ".str", "_a.mus", "_b.mus");
    private static final String ERR_SIDTUNE_INVALID = "MUS: file contains invalid data";
    private static final String ERR_SIDTUNE_2ND_INVALID = "MUS: 2nd file contains invalid data";
    private static final int MUS_HLT_CMD = 335;
    private static final int MUS_DATA_ADDR = 2304;
    private static final int DUAL_SID_BASE = 54528;
    private int musDataLen;
    private KickAssemblerResult preparedDriver;
    private KickAssemblerResult preparedStereoDriver;

    Mus() {
    }

    @Override
    public Integer placeProgramInMemory(byte[] c64buf) {
        if (USE_KICKASSEMBLER) {
            this.assembleAndinstallMusPlayers(c64buf);
        } else {
            this.relocateAndInstallMusPlayers(c64buf);
        }
        return super.placeProgramInMemory(c64buf);
    }

    private int detect(File musFile, byte[] buffer, String errorMessage) throws SidTuneError {
        String suffix = IOUtils.getFilenameSuffix(musFile.getName().toLowerCase(Locale.ENGLISH));
        if (!DEFAULT_MUS_NAMES.stream().anyMatch(ext -> suffix.endsWith((String)ext))) {
            throw new SidTuneError(errorMessage);
        }
        if (buffer == null || buffer.length < 8) {
            throw new SidTuneError(errorMessage);
        }
        int voice1DataEnd = 8 + (buffer[2] & 0xFF) + ((buffer[3] & 0xFF) << 8);
        int voice2DataEnd = voice1DataEnd + (buffer[4] & 0xFF) + ((buffer[5] & 0xFF) << 8);
        int voice3DataEnd = voice2DataEnd + (buffer[6] & 0xFF) + ((buffer[7] & 0xFF) << 8);
        if (voice3DataEnd - 1 >= buffer.length || (buffer[voice1DataEnd - 1] & 0xFF) + ((buffer[voice1DataEnd - 2] & 0xFF) << 8) != 335 || (buffer[voice2DataEnd - 1] & 0xFF) + ((buffer[voice2DataEnd - 2] & 0xFF) << 8) != 335 || (buffer[voice3DataEnd - 1] & 0xFF) + ((buffer[voice3DataEnd - 2] & 0xFF) << 8) != 335) {
            throw new SidTuneError(errorMessage);
        }
        return voice3DataEnd;
    }

    protected static SidTune load(File musFile, byte[] dataBuf) throws SidTuneError {
        Mus mus = new Mus();
        mus.loadWithProvidedMetadata(musFile, dataBuf);
        return mus;
    }

    private void loadWithProvidedMetadata(File musFile, byte[] musBuf) throws SidTuneError {
        int voice3DataEnd = this.detect(musFile, musBuf, ERR_SIDTUNE_INVALID);
        this.musDataLen = musBuf.length;
        if (voice3DataEnd < musBuf.length) {
            String credits = this.getCredits(musBuf, voice3DataEnd);
            this.info.commentString.add(credits);
            voice3DataEnd += credits.length() + 1;
        }
        byte[] strBuf = null;
        File stereoFile = Mus.getStereoTune(musFile);
        if (stereoFile != null) {
            try {
                strBuf = Mus.getContents(stereoFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (strBuf != null) {
            voice3DataEnd = this.detect(stereoFile, strBuf, ERR_SIDTUNE_2ND_INVALID);
            if (voice3DataEnd < strBuf.length) {
                this.info.commentString.add(this.getCredits(strBuf, voice3DataEnd));
            }
            this.info.sidChipBase[1] = 54528;
        }
        this.info.loadAddr = 2304;
        this.info.compatibility = SidTune.Compatibility.PSIDv2;
        this.info.infoString.add(IOUtils.getFilenameWithoutSuffix(musFile.getName()));
        this.info.infoString.add("<?>");
        this.info.infoString.add("<?>");
        this.program = new byte[musBuf.length + (strBuf != null ? strBuf.length : 0)];
        this.info.c64dataLen = this.program.length;
        System.arraycopy(musBuf, 0, this.program, 0, musBuf.length);
        if (strBuf != null) {
            System.arraycopy(strBuf, 0, this.program, musBuf.length, strBuf.length);
        }
        this.findPlaceForDriver();
    }

    private String getCredits(byte[] musBuf, int voice3DataEnd) {
        byte[] creditsBytes = Arrays.copyOfRange(musBuf, voice3DataEnd, musBuf.length - 1);
        return CBMCodeUtils.petsciiToIso88591(creditsBytes);
    }

    private static File getStereoTune(File file) {
        File[] siblings = file.getParentFile().listFiles((dir, name) -> {
            String suffix = IOUtils.getFilenameSuffix(name.toLowerCase(Locale.ENGLISH));
            return DEFAULT_MUS_NAMES.stream().filter(ext -> suffix.endsWith((String)ext)).findFirst().isPresent();
        });
        for (String extension : DEFAULT_MUS_NAMES) {
            String test = file.getName().replaceFirst("(_[aA]|_[bB])?\\.\\w+$", extension);
            if (file.getName().equalsIgnoreCase(test)) continue;
            for (File sibling : siblings) {
                if (!sibling.getName().equalsIgnoreCase(test)) continue;
                return sibling;
            }
        }
        return null;
    }

    @Override
    public void prepare() {
        if (USE_KICKASSEMBLER) {
            InputStream asm = Mus.class.getResourceAsStream(MUS_DRIVER1_ASM);
            this.preparedDriver = KickAssembler.assemble(MUS_DRIVER1_ASM, asm, new HashMap<String, String>());
            this.checkLabels(MUS_DRIVER1_ASM, this.preparedDriver.getResolvedSymbols(), "data_low", "data_high", "init", "start");
            this.info.initAddr = this.preparedDriver.getResolvedSymbols().get("init");
            this.info.playAddr = this.preparedDriver.getResolvedSymbols().get("start");
            if (this.info.getSIDChipBase(1) != 0) {
                InputStream stereoAsm = Mus.class.getResourceAsStream(MUS_DRIVER2_ASM);
                this.preparedStereoDriver = KickAssembler.assemble(MUS_DRIVER2_ASM, stereoAsm, new HashMap<String, String>());
                this.checkLabels(MUS_DRIVER2_ASM, this.preparedStereoDriver.getResolvedSymbols(), "data_low", "data_high", "init", "start");
                this.info.initAddr = this.preparedStereoDriver.getResolvedSymbols().get("init");
                this.info.playAddr = this.preparedStereoDriver.getResolvedSymbols().get("start");
            }
            super.prepare();
        }
    }

    private void assembleAndinstallMusPlayers(byte[] c64buf) {
        if (this.preparedDriver == null) {
            this.prepare();
        }
        this.installMusPlayer(c64buf, 2304, this.preparedDriver.getData(), this.preparedDriver.getResolvedSymbols().get("data_low"), this.preparedDriver.getResolvedSymbols().get("data_high"));
        if (this.info.getSIDChipBase(1) != 0) {
            this.installMusPlayer(c64buf, 2304 + this.musDataLen, this.preparedStereoDriver.getData(), this.preparedStereoDriver.getResolvedSymbols().get("data_low"), this.preparedStereoDriver.getResolvedSymbols().get("data_high"));
        }
    }

    private void checkLabels(String asmSource, Map<String, Integer> resolvedSymbols, String data_low, String data_high, String init, String start) {
        if (resolvedSymbols.get(data_low) == null) {
            throw new RuntimeException("Symbol data_low not found in " + asmSource);
        }
        if (resolvedSymbols.get(data_high) == null) {
            throw new RuntimeException("Symbol data_high not found in " + asmSource);
        }
        if (resolvedSymbols.get(init) == null) {
            throw new RuntimeException("Symbol init not found in " + asmSource);
        }
        if (resolvedSymbols.get(start) == null) {
            throw new RuntimeException("Symbol start not found in " + asmSource);
        }
    }

    private void relocateAndInstallMusPlayers(byte[] c64buf) {
        byte[] MUS_DRIVER1;
        try (DataInputStream is = new DataInputStream(Mus.class.getResourceAsStream(MUS_DRIVER1_BIN));){
            URL url = Mus.class.getResource(MUS_DRIVER1_BIN);
            MUS_DRIVER1 = new byte[url.openConnection().getContentLength()];
            is.readFully(MUS_DRIVER1);
        }
        catch (IOException e) {
            throw new RuntimeException("Load failed for resource: /libsidplay/sidtune/musdriver1.bin");
        }
        int dest = (MUS_DRIVER1[0] & 0xFF) + ((MUS_DRIVER1[1] & 0xFF) << 8);
        this.installMusPlayer(c64buf, 2304, MUS_DRIVER1, dest + 3182 - 1, dest + 3184 - 1);
        this.info.initAddr = 60512;
        this.info.playAddr = 60544;
        if (this.info.getSIDChipBase(1) != 0) {
            byte[] MUS_DRIVER2;
            try (DataInputStream is = new DataInputStream(Mus.class.getResourceAsStream(MUS_DRIVER2_BIN));){
                URL url = Mus.class.getResource(MUS_DRIVER2_BIN);
                MUS_DRIVER2 = new byte[url.openConnection().getContentLength()];
                is.readFully(MUS_DRIVER2);
            }
            catch (IOException e) {
                throw new RuntimeException("Load failed for resource: /libsidplay/sidtune/musdriver2.bin");
            }
            dest = (MUS_DRIVER2[0] & 0xFF) + ((MUS_DRIVER2[1] & 0xFF) << 8);
            this.installMusPlayer(c64buf, 2304 + this.musDataLen, MUS_DRIVER2, dest + 3182 - 1, dest + 3184 - 1);
            this.info.initAddr = 64656;
            this.info.playAddr = 64662;
        }
    }

    private void installMusPlayer(byte[] c64buf, int musDataAddr, byte[] driver, Integer data_low, Integer data_high) {
        int driverAddr = (driver[0] & 0xFF) + ((driver[1] & 0xFF) << 8);
        System.arraycopy(driver, 2, c64buf, driverAddr, driver.length - 2);
        c64buf[data_low.intValue() + 1] = (byte)(2 + musDataAddr & 0xFF);
        c64buf[data_high.intValue() + 1] = (byte)(2 + musDataAddr >> 8);
    }

    @Override
    public void save(String name) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(!name.endsWith(".mus") ? name + ".mus" : name);){
            fos.write(this.program);
        }
    }
}

